const validator = require("validator");
const { getAdminByUsername, getAdminByEmail, deleteAdminTokens, createAdminTokens } = require("../../../helpers/admin");
const asyncHandler = require("../../../helpers/asyncHandler");
const { signToken } = require("../../../helpers/jwt");
const { comparePassword } = require("../../../helpers/password");

//REFRESH LOGIN (POST)
exports.adminRefreshLoginPost = asyncHandler(async (req, res, next) => {
    return res.json({ status: true, data: { user: req.user }});
})

//LOGIN (POST)
exports.adminLoginPost = asyncHandler(async (req, res, next) => {

    const isEmail = validator.isEmail(req.body.credentials || '');
    
    //USER VARIABLE
    let user;

    if (isEmail) {
       user = await getAdminByEmail(req.body.credentials || "")
    } else {
        user = await getAdminByUsername(req.body.credentials || "")
    };

    if (!user) {
        return res.json({status:false,message:"User not found"})
    };

    //Checking Password
    const isPasswordSame = await comparePassword(req.body.password, user.password);
    
    
    if (!isPasswordSame) {
        return res.json({status:false,message:"Incorrect Password"})
    }

    //Sign User A Token And Respond
    const token = await signToken({ id: user.uid }, { expiresIn: req.body.keepLogged ? "7d" : "1h" });

    //DELETE ALL TOKENS
    await deleteAdminTokens(user.uid);

    //SAVED SIGNIN TOKEN TO DATABASE
    await createAdminTokens({
        at_user_id: user.uid,
        at_token: token
    });

    //Checking Where To Send Him To
    return res.json({ status:true, message: `Welcome ${user.username}`, data: { user, token }})

});

exports.adminLogout = asyncHandler(async (req, res, next) => {

    //DELETE ALL TOKENS
    await deleteAdminTokens(req.user.uid);

    return res.json({ status: true, message: `Goodbye! ${req.user.username}`});
});