const fs = require("fs");
const path = require("path");
const asyncHandler = require("../../../helpers/asyncHandler");
const { getPaginationNextPrev, getNextOffset } = require("../../../helpers/pagination");
const { getVideoUploads, deleteUploadById, deleteUploads } = require("../../../helpers/uploadVideo");
const { deleteFileAttachmentMulter } = require("../../../multer/multerMiddleware");
const { adminPostPost } = require("../post/all-post");

//ADMIN GET ALL CONTENT Submissions
exports.adminAllContentSubmissionsGet = asyncHandler(async (req, res, next) => {

    const limit = req.query.limit || parseInt(process.env.LIMIT), currentPage = parseInt(req.query.page) || 1, search = req.query.search;

    const { totalCount, data } = await getVideoUploads({
        query: { search, limit, offset: getNextOffset(currentPage, limit) }
    });

    const { prevPage, nextPage, totalPages } = getPaginationNextPrev({ page: currentPage, limit, totalCount});


    res.json({ status: true, data: { data, pagination: { currentPage, prevPage, nextPage, totalPages } }})
});

//CONTENT SUBMISSIONS (POST)
exports.adminContentSubmissionsPost = asyncHandler(async (req, res, next) => {

    req.theMode = "submission";
    
    const result = await adminPostPost(req, res, next);

    if(result.status){
        deleteUploadById(req.query.id)
    }

    return res.json(result)

});


//CONTENT SUBMISSIONS (DELETE)
exports.adminContentSubmissionsDelete = asyncHandler(async (req, res, next) => {

    const { deletedRows, deletedData } = await deleteUploads(req.body)
    
    let message = "";
    if(deletedRows > 1) message = `${deletedRows} Submissions Deleted`
    else if(deletedRows == 1) message = "Submission Deleted";
    else message = "No Submission Deleted"

    res.json({ status: Boolean(deletedRows), message });

    const deleteTasks = [];

    deletedData.forEach(row => {
        if (row.u_video_link) deleteTasks.push(deleteFileAttachmentMulter(path.join(__basedir, 'public', row.u_video_link)));

        if (row.u_thumbnail_link) deleteTasks.push(deleteFileAttachmentMulter(path.join(__basedir, 'public', row.u_thumbnail_link)));
    });

    Promise.allSettled(deleteTasks)
})