const { logAdminActivity } = require("../../../helpers/admin");
const asyncHandler = require("../../../helpers/asyncHandler");
const { adminGetLogs, clearAllLogs } = require("../../../helpers/logs");
const { getNextOffset, getPaginationNextPrev } = require("../../../helpers/pagination");

//GET LOGS
exports.adminLogsGet = asyncHandler(async (req, res, next) => {

    const limit = req.query.limit || parseInt(process.env.LIMIT), currentPage = parseInt(req.query.page) || 1, type = req.query.type || "all", search = req.query.search;

    const { totalCount, logs } = await adminGetLogs({
        query: { type, search, limit, offset: getNextOffset(currentPage, limit) }
    });

    const { prevPage, nextPage, totalPages } = getPaginationNextPrev({ page: currentPage, limit, totalCount});

    res.json({ status: true, data: { logs, pagination: { currentPage, prevPage, nextPage, totalPages } }})
});

//CLEAR LOGS
exports.adminLogsDelete = asyncHandler(async (req, res, next) => {

    await Promise.all([
        clearAllLogs(),
        logAdminActivity({ aa_admin_id: req.user.uid, aa_content: "Cleared logs" })
    ]);

    return res.json({ status: true, message: "Logs cleared successfully" })
});
