const { logAdminActivity } = require("../../../helpers/admin");
const asyncHandler = require("../../../helpers/asyncHandler");
const { slugMaker } = require("../../../helpers/dataManipulator");
const { updatePageById, createPageFunction, getPageFunction, deletePages } = require("../../../helpers/page");

exports.adminPageGet = asyncHandler(async (req, res, next) => {
   
    let pages = await getPageFunction(999999999, 0);
    
    return res.json({ status: true, data: pages })

})

//ADD PAGE (POST)
exports.adminPagePost = asyncHandler(async (req, res, next) => {
    
    try{

        const data = {
            ...req.body,
            page_author: req.user.uid,
            page_slug: slugMaker(req.body.page_slug || req.body.page_title)
        };

        const [ createPageResult ] = await Promise.all([
            createPageFunction(data),
            logAdminActivity({
                aa_admin_id: req.user.uid,
                aa_content: `Created new page "${req.body.page_title}"`
            })
        ]);
        

        data.page_id = createPageResult.insertId;
        data.page_created_at = new Date();

        return res.json({ status: true, message: "Page Created", data })

    } catch (error) {
        let message;

        if (error.sqlMessage?.includes("page_title") || error.sqlMessage?.includes("page_slug")) {
            message = "Page already exists"
        } else message = error?.sqlMessage || "Something went wrong";

        //Response To Client
        return res.json({ status: false, message })

    };
});

//EDIT PAGE (PUT)
exports.adminPagePut = asyncHandler(async (req, res, next) => {

    try{

        const data = { ...req.body, page_slug: slugMaker(req.body.page_slug || req.body.page_title) };

        await Promise.all([
            updatePageById(data, req.body.page_id),
            logAdminActivity({
                aa_admin_id: req.user.uid,
                aa_content: `Edited page "${req.body.page_title}"`
            })
        ]);

        return res.json({ status: true, message: "Changes Saved", data });

    } catch (error) {
        let message;

        if (error.sqlMessage?.includes("page_title") || error.sqlMessage?.includes("page_slug")) {
            message = "Page already exists"
        } else message = error?.sqlMessage || "Something went wrong";

        //Response To Client
        return res.json({ status: false, message })

    };

})

//DELETE PAGE (DELETE)
exports.adminPageDelete = asyncHandler(async (req, res, next) => {

    const { count: deletedCount } = await deletePages(req.body);

    await logAdminActivity({
        aa_admin_id: req.user.uid,
        aa_content: `Deleted ${deletedCount} Page${deletedCount > 1 ? 's' : ''}`
    })
    
    let message = "";
    if(deletedCount > 1) message = `${deletedCount} Pages Deleted`
    else if(deletedCount == 1) message = "Page Deleted";
    else message = "No Page Deleted"

    res.json({ status: Boolean(deletedCount), message });

})

