const asyncHandler = require("../../../helpers/asyncHandler");
const { saveSettings, getWebSettings } = require("../../../helpers/settings");
const path = require("path");
const fs = require("fs");
const { modifyObject } = require("../../../helpers/dataManipulator");
const { adminGetReferralRewards, createNewReferralReward, editReferralRewardById, deleteReferralRewardById } = require("../../../helpers/referralRewards");
const { testTransporter } = require("../../../email/transporter");


//WEB SETTINGS
exports.adminWebSettingsGet = asyncHandler(async (req, res, next) => {
    let webSettings = await getWebSettings();

    const excludedData = [];

    webSettings = modifyObject(webSettings, excludedData);

    return res.json({ status: true, data: webSettings })
})

//ADMIN SETTING SAVED (POST)
exports.adminSettingsPost = asyncHandler(async (req, res, next) => {
    if (!req.query.identity) {
        if(req.query.smtp){

            //Test The Connection
            const result = await testTransporter(JSON.parse(req.body.website_mailer));
            if(result.status) await saveSettings(req.body); 
            return res.json(result);

        }else{
            await saveSettings(req.body);  
        }

    } else {

        try {
            const imageUpdates = await Promise.all(req.compressedImgs.map(async (file) => {
                const { fieldname, buffer } = file;
                
                // Generate unique filename (webp format)
                const filename = `${fieldname}.webp`;
                const filePath = path.join(__basedir, fieldname == 'website_watermark' ? 'public/files/images' : 'public/img/identity', filename);
                
                // Save file to disk
                await fs.promises.writeFile(filePath, buffer);
                
                // Return the fieldname and saved path for DB update
                return {
                    field: fieldname,
                    value: fieldname == 'website_watermark' ? `/files/images/${filename}` : `/img/identity/${filename}`
                };
            }));
            
            const data = {};

            await Promise.all(imageUpdates.map(async ({ field, value }) => {
                await saveSettings({ [field]: value });
                data[field] = value;
            }));

            return res.json({ status: true, message:"Changes Saved", data })
        } catch (error) {
            throw Error(error)
        };
        
    }
    
    return res.json({status:true,message:"Changes Saved"})
});


//REFERRAL REWARDS SETTINGS
exports.adminReferralRewardsSettingsGet = asyncHandler(async (req, res, next) => {
    
    const rewards = await adminGetReferralRewards();

    return res.json({ status: true, data: rewards })
})

//REFERRAL REWARDS SETTINGS (POST)
exports.adminReferralRewardsSettingsPost = asyncHandler(async (req, res, next) => {
    
    try{
        const { insertId } = await createNewReferralReward(req.body);
        return res.json({ status: true, message: "Reward added", data: insertId })

    } catch (error) {
        
        let message;
        if (error.sqlMessage.includes("g_service_id")) {
            message = "Reward already created"
        } else message = error.sqlMessage;

        //Response To Client
        return res.json({ status: false, message })
    }
    
})

//REFERRAL REWARDS SETTINGS (PUT)
exports.adminReferralRewardsSettingsPut = asyncHandler(async (req, res, next) => {
    
    const { affectedRows } = await editReferralRewardById(req.query.id, req.body);

    if(affectedRows) return res.json({ status: true, message: "Reward updated" })
    else return res.json({ status: false, message: "Failed to update"});

})

//REFERRAL REWARDS SETTINGS (DELETE)
exports.adminReferralRewardsSettingsDelete = asyncHandler(async (req, res, next) => {
    
    const { affectedRows } = await deleteReferralRewardById(req.query.id)
    if(affectedRows) return res.json({ status: true, message: "Reward deleted" })
    else return res.json({ status: false, message: "Failed to delete"});
    
})