const asyncHandler = require("../../../helpers/asyncHandler");
const { getNextOffset, getPaginationNextPrev } = require("../../../helpers/pagination");
const { hashPassword } = require("../../../helpers/password");
const { adminGetUsers, getUserMoreinfo, editUserById, editUserEssentials, deleteUsers, getUserFullData } = require("../../../helpers/user");
const { userRegisterPost } = require("../../user/auth/auth");


//ADMIN USER MANAGEMENT
exports.adminUserManagementGet = asyncHandler(async (req, res, next) => {

    const limit = req.query.limit || parseInt(process.env.LIMIT), currentPage = parseInt(req.query.page) || 1, type = req.query.type || "all", search = req.query.search;

    const { totalCount, users } = await adminGetUsers({
        query: { type, search, limit, offset: getNextOffset(currentPage, limit) }
    });

    const { prevPage, nextPage, totalPages } = getPaginationNextPrev({ page: currentPage, limit, totalCount});


    res.json({ status: true, data: { users, pagination: { currentPage, prevPage, nextPage, totalPages } }})
});

//USER DEEP INFO
exports.adminUserManagementDeepInfoGet = asyncHandler(async (req, res, next) => {

    const infos = await getUserMoreinfo(req.query.id || 0);

    res.json({ status: true, data: infos })
    
});

//ADMIN NEW USER
exports.adminUserManagementPost = asyncHandler(async (req, res, next) => {

    const result = await userRegisterPost(req, res, next);

    if(!result.status) return res.json({ status: false, message: result.message });

    const userDetails = await getUserFullData(result.data);

    return res.json({ status: true, message: "User Created", data: userDetails });

    
    
});

//ADMIN UPDATE USER
exports.adminUserManagementPut = asyncHandler(async (req, res, next) => {

    Object.keys(req.body.basicInfo).length && await editUserById(req.query.id, req.body.basicInfo);
    Object.keys(req.body.essentialInfo).length && await editUserEssentials({ userId: req.query.id, data: req.body.essentialInfo });

    res.json({ status: true, message: "User Updated" })
    
});

//ADMIN DELETE USER(s)
exports.adminUserManagementDelete = asyncHandler(async (req, res, next) => {

    const deletedCount = await deleteUsers(req.body);
    
    let message = "";
    if(deletedCount > 1) message = `${deletedCount} Users Deleted`
    else if(deletedCount == 1) message = "User Deleted";
    else message = "No User Deleted"

    res.json({ status: Boolean(deletedCount), message })
    
});
