const { LIKES_MULTIPLIER } = require("../../../extras/constants");
const asyncHandler = require("../../../helpers/asyncHandler");
const { stripTextFromHtml } = require("../../../helpers/dataManipulator");
const formatNumber = require("../../../helpers/formatNumber");
const { getPaginationNextPrev, getNextOffset } = require("../../../helpers/pagination");
const { getCategoryBySlug, getCategoryPosts } = require("../../../helpers/post");
const moment = require('moment');
const url = require('url');

//CATEGORY
exports.categoryGet = asyncHandler(async (req, res, next) => {
    const { slug } = req.params;
    const category = await getCategoryBySlug(slug ?? '');
    
    if (!category) {
        return res.status(404).render("general/page/404", { 
            title: "Resource Not Found",
            description: "The requested category could not be found."
        });
    }

    
    const limit = parseInt(req.query.limit) || parseInt(process.env.LIMIT) || 2, currentPage = parseInt(req.query.page) || 1, search = req.query.search, production = req.query.production, quality = req.query.quality, duration = req.query.duration, sortBy = req.query.sortBy || 'latest';
    
    const {posts, totalCount} = await getCategoryPosts({ query: { 
        catId: category.cc_id, 
        search, 
        quality,
        duration,
        production,
        sortBy,
        limit, 
        offset: getNextOffset(currentPage, limit) 
    } });

    const { prevPage, nextPage, totalPages } = getPaginationNextPrev({ page: currentPage, limit, totalCount });
    
    let currentUrl = url.parse(req.originalUrl).pathname, paginationLink = currentUrl, useNd = false;

    if (search) {
        paginationLink = `${paginationLink}?search=${search}&`;
        useNd = true;
    }
    if (!useNd) paginationLink = `?`;

    const thumbnail = category.cc_thumbnail || (posts[Math.floor(Math.random() * posts.length)] || {}).c_thumbnail;

    return res.render("general/page/Blog/category",{
        title: `${category.cc_name} - ${res.locals.websiteDetails.website_title}`,
        description: stripTextFromHtml(category.cc_description || res.locals.websiteDetails.website_description).substring(0, 160),
        category,
        thumbnail: thumbnail ? `${res.locals.homeUrl}${thumbnail}` : '',
        search: search || '',
        production,
        quality,
        duration,
        sortBy,
        data: { 
            posts: posts.map(post => ({
                ...post,
                c_likes2: formatNumber(post.c_likes * LIKES_MULTIPLIER),
                formatDate: moment(post.c_created_at).format('MMM D, YYYY, h:mm A')
            })),
            pagination: { currentPage, prevPage, nextPage, totalPages, paginationLink }
        }
    })
})