const asyncHandler = require("../../../helpers/asyncHandler");
const { stripTextFromHtml } = require("../../../helpers/dataManipulator");
const { userGetPageBySlug } = require("../../../helpers/page");

//SINGLE PAGE
exports.singlePageGet = asyncHandler(async (req, res, next) => {

    const { slug } = req.params, webSettings = res.locals.websiteDetails;;

    // If the slug is 'about' or 'about-us', render the about page directly
    if(slug.toLowerCase() == 'about' || slug.toLowerCase() == 'about-us') {
        return res.render("general/page/Page/about",{
            title: `About Us - ${webSettings.website_title}`,
            description: webSettings.website_description
        })
    }

    // If the slug is 'contact' or 'contact-us', render the contact page directly
    else if(slug.toLowerCase() == 'contact' || slug.toLowerCase() == 'contact-us') {
        return res.render("general/page/Page/contact",{
            title: `Contact Us - ${webSettings.website_title}`,
            description: webSettings.website_description
        })
    };

    const page = await userGetPageBySlug(slug ?? '');
    
    if (!page) {
        return res.status(404).render("general/page/404", { 
            title: "Resource Not Found",
            description: "The requested page could not be found."
        });
    }

    let description = stripTextFromHtml(page.page_description || '').substring(0, 160);
    
    return res.render("general/page/Page",{
        title: `${page.page_title} - ${webSettings.website_title}`,
        description,
        data: { 
            ...page, 
            description: stripTextFromHtml(page.page_description || webSettings.website_description)
        }
    })
})