const asyncHandler = require("../../../helpers/asyncHandler");
const { signResetPasswordToken, openToken } = require("../../../helpers/jwt");
const { insertVideo, editUploadById } = require("../../../helpers/uploadVideo");
const path = require("path");
const fsPromises = require('fs').promises;
const { generateRandomId } = require("../../../helpers/uniqueID");
const { slugMaker } = require("../../../helpers/dataManipulator");
const mime = require('mime-types');

//UPLOAD VIDEO PAGE
exports.uploadVideoPageGet = asyncHandler(async (req, res, next) => {

    const webSettings = res.locals.websiteDetails;

    let isTokenValid = false;
    try {
        if(req.query.token) {
            try {
                isTokenValid = await openToken(req.query.token);
            } catch (error) {
                isTokenValid = false;
            }
        }
    } catch (error) {
        
    }

    if(isTokenValid) {

        return res.render("general/page/Page/success", {
            title: `Request Submitted - ${webSettings.website_title}`,
            description: webSettings.website_description,
            token: req.query.token
        });
    }
    else{
        return res.render("general/page/Page/submit",{
            title: `Upload Video Form - ${webSettings.website_title}`,
            description: webSettings.website_description
        })
    }
    

})

//UPLOAD VIDEO PAGE (POST)
exports.uploadVideoPagePost = asyncHandler(async (req, res, next) => {
    const videoFile = req.compressedFiles.find(cf => cf.fieldname === "video_file");
    const thumbnailFile = req.compressedFiles.find(cf => cf.fieldname === "thumbnail");

    // Insert video metadata
    const { insertId } = await insertVideo({
        u_fullname: req.body.fullname,
        u_email: req.body.email,
        u_backlink: req.body.backlink,
        u_title: req.body.video_title,
        u_description: req.body.video_description
    });

    const writeTasks = [];
    let videoPathRelative = null;
    let thumbnailPathRelative = null;

    // If video exists
    if (videoFile) {
        const videoFileName = `${slugMaker(req.body.video_title)}-${generateRandomId()}.${mime.extension(videoFile.fileType)}`;
        const videoFilePath = path.join(__basedir, "public/files/videos", videoFileName);
        videoPathRelative = `/files/videos/${videoFileName}`;
        writeTasks.push(fsPromises.writeFile(videoFilePath, videoFile.buffer));
    }

    // If thumbnail exists
    if (thumbnailFile) {
        const thumbFileName = `${slugMaker(req.body.video_title)}-${generateRandomId()}.${mime.extension(thumbnailFile.fileType)}`;
        const thumbFilePath = path.join(__basedir, "public/files/images", thumbFileName);
        thumbnailPathRelative = `/files/images/${thumbFileName}`;
        writeTasks.push(fsPromises.writeFile(thumbFilePath, thumbnailFile.buffer));
    }

    // Wait for both (or either) writes to finish
    await Promise.all(writeTasks);

    // Update video record with file paths
    await editUploadById(insertId, {
        u_video_link: videoPathRelative,
        u_thumbnail_link: thumbnailPathRelative
    });

    const token = await signResetPasswordToken(req.body, "30s");
    return res.redirect("?token=" + token);
});