const db = require("../models/db");

//CREATE ADMIN
exports.createAdmin = (obj) => {
    return new Promise((resolve, reject) => {
        db.query("INSERT INTO f_admins SET ?", obj, (err, data) => {
            if (err) reject(err)
            else resolve(data)
        })
    })
};

//GET ADMIN BY ID
exports.getAdminById = (adminId) => {
    return new Promise((resolve, reject) => {
        db.query("SELECT * FROM f_admins WHERE uid = ? LIMIT 1", parseInt(adminId), (err, user) => {
            if (err) reject(err)
            else resolve(user[0])
        })
    })
};

//GET ADMIN BY USERNAME
exports.getAdminByUsername = (username) => {
    return new Promise((resolve, reject) => {
        db.query("SELECT * FROM f_admins WHERE username = ? LIMIT 1",username, (err, user) => {
            if (err) reject(err)
            else resolve(user[0])
        })
    })
}


//GET ADMIN BY EMAIL
exports.getAdminByEmail = (email) => {
    return new Promise((resolve, reject) => {
        db.query("SELECT * FROM f_admins WHERE email = ? LIMIT 1",email, (err, user) => {
            if (err) reject(err)
            else resolve(user[0])
        })
    })
}

//UPDATE ADMIN BY ID
exports.updateAdminById = (id,obj) => {
    return new Promise((resolve, reject) => {
        db.query("UPDATE f_admins SET ? WHERE uid = ?",[obj,parseInt(id)], (err, data) => {
            if (err) reject(err)
            else resolve(data)
        })
    })
}



//CREATE NEW ADMIN TOKENS
exports.createAdminTokens = (obj) => {
    return new Promise((resolve, reject) => {
        db.query("INSERT INTO f_admin_tokens SET ?", obj, (err, data) => {
            if (err) reject(err)
            else resolve(data)
        })
    })
};

//DELETE ADMIN TOKENS
exports.deleteAdminTokens = (userId) => {
    return new Promise((resolve, reject) => {
        db.query("DELETE FROM f_admin_tokens WHERE at_user_id = ?", parseInt(userId), (err, user) => {
            if (err) reject(err)
            else resolve(user)
        })
    })
};

//GET ADMIN TOKEN
exports.getAdminToken = (token) => {
    return new Promise((resolve, reject) => {
        db.query("SELECT * FROM f_admin_tokens WHERE at_token = ?", token, (err, data) => {
            if (err) reject(err)
            else resolve(data[0])
        })
    })
};


//ADMIN GET USERS
exports.adminGetAdmins = (obj) => {
    return new Promise(async (resolve, reject) => {
        try {
            // Build dynamic filters
            let filters = `WHERE NOT uid = ${obj.userId} AND NOT role = 'super'`;

            if (obj.query.type && obj.query.type !== 'all') {
                filters += ` AND role = '${obj.query.type}'`;
            }
            if (obj.query.search) {
                filters += ` AND (fullname LIKE '%${obj.query.search}%' OR username LIKE '%${obj.query.search}%' OR email LIKE '%${obj.query.search}%')`;
            }

            // Build SQL queries for pagination
            const query = `SELECT * FROM f_admins ${filters} LIMIT ${obj.query.limit} OFFSET ${obj.query.offset};`;
            
            const countQuery = `SELECT COUNT(*) as totalCount FROM f_admins ${filters};`;

            const dbInstance = obj.connection || db;

            const [dataResult, countResult] = await Promise.all([
                new Promise((res, rej) => dbInstance.query(query, (err, data) => err ? rej(err) : res(data))),
                new Promise((res, rej) => dbInstance.query(countQuery, (err, data) => err ? rej(err) : res(data))),
            ]);

            return resolve({
                users: dataResult,
                totalCount: countResult[0].totalCount
            });

        } catch (err) {
            return reject(err);
        }
    });
};

//GET ADMIN ACTIVITIES
exports.getAdminActivities = (obj) => {
    return new Promise(async (resolve, reject) => {
        try {
            // Build dynamic filters
            let filters = `WHERE aa_admin_id = ${obj.userId}`;

            // Date filtering
            if (obj.query.from) {
                filters += ` AND aa_created_at >= '${obj.query.from} 00:00:00'`;
            }
            
            if (obj.query.to) {
                filters += ` AND aa_created_at <= '${obj.query.to} 23:59:59'`;
            }

            // Build SQL queries for pagination
            const query = `SELECT * FROM f_admin_activities ${filters} ORDER BY aa_id DESC LIMIT ${obj.query.limit} OFFSET ${obj.query.offset};`;
            
            const countQuery = `SELECT COUNT(*) as totalCount FROM f_admin_activities ${filters};`;

            const dbInstance = obj.connection || db;

            const [dataResult, countResult] = await Promise.all([
                new Promise((res, rej) => dbInstance.query(query, (err, data) => err ? rej(err) : res(data))),
                new Promise((res, rej) => dbInstance.query(countQuery, (err, data) => err ? rej(err) : res(data))),
            ]);

            return resolve({
                activities: dataResult,
                totalCount: countResult[0].totalCount
            });

        } catch (err) {
            return reject(err);
        }
    });
};

// DELETE MULTIPLE ADMINS
exports.deleteAdmins = (userIds) => {
    return new Promise((resolve, reject) => {
        // Check if userIds is an array and not empty
        if (!Array.isArray(userIds) || userIds.length === 0) {
            return resolve(0); // Return 0 if no users to delete
        }

        // Convert all IDs to numbers to prevent SQL injection
        const sanitizedIds = userIds.map(id => parseInt(id)).filter(id => !isNaN(id));
        
        if (sanitizedIds.length === 0) {
            return resolve(0); // Return 0 if no valid IDs
        }

        // Create placeholders for the query (?, ?, ? etc.)
        const placeholders = sanitizedIds.map(() => '?').join(',');
        
        db.query(
            `DELETE FROM f_admins WHERE uid IN (${placeholders})`,
            sanitizedIds,
            (err, result) => {
                if (err) {
                    reject(err);
                } else {
                    // Return the number of affected (deleted) rows
                    resolve(result.affectedRows);
                }
            }
        );
    });
};

//ADMIN GET WALLETS BALANCE
exports.getApiWalletsBalance = () => {
    return new Promise((resolve, reject) => {
        db.query("SELECT * FROM f_api_wallets_balance", (err, data) => {
            if (err) reject(err)
            else resolve(data)
        })
    })
};

//ADMIN UPDATE WALLET BALANCE
exports.updateApiWalletsBalanceById = (id, data) => {
    return new Promise((resolve, reject) => {
        db.query("UPDATE f_api_wallets_balance SET ? WHERE awb_id = ?", [data, id], (err, data) => {
            if (err) reject(err)
            else resolve(data)
        })
    })
};


//LOG ADMIN ACTIVITY
exports.logAdminActivity = (obj) => {
    return new Promise((resolve, reject) => {
        db.query("INSERT INTO f_admin_activities SET ?", obj, (err, data) => {
            if (err) reject(err)
            else resolve(data)
        })
    })
};