const db = require("../models/db");

//CREATE NEW
exports.insertContentRemoval = (obj) => {
    return new Promise((resolve, reject) => {
        db.query("INSERT INTO f_contents_removal SET ?", obj, (err, data) => {
            if (err) reject(err)
            else resolve(data)
        })
    })
};

//GET CONTENT REMOVAL
exports.getContentRemovals = (obj) => {
    return new Promise(async (resolve, reject) => {
        try {
            // Build dynamic filters
            let filters = `WHERE 1 + 1`;

            if (obj.query.search) {
                filters += ` AND (cr_fullname LIKE '%${obj.query.search}%' OR cr_email LIKE '%${obj.query.search}%' OR cr_links LIKE '%${obj.query.search}%')`;
            }
            
            if (obj.query.status) {
                filters += ` AND cr_status = '${obj.query.status}'`;
            }

            // Build SQL queries for pagination
            const query = `SELECT * FROM f_contents_removal ${filters} LIMIT ${obj.query.limit} OFFSET ${obj.query.offset};`;
            
            const countQuery = `SELECT COUNT(*) as totalCount FROM f_contents_removal ${filters};`;

            const dbInstance = obj.connection || db;

            const [dataResult, countResult] = await Promise.all([
                new Promise((res, rej) => dbInstance.query(query, (err, data) => err ? rej(err) : res(data))),
                new Promise((res, rej) => dbInstance.query(countQuery, (err, data) => err ? rej(err) : res(data))),
            ]);

            return resolve({
                data: dataResult,
                totalCount: countResult[0].totalCount
            });

        } catch (err) {
            return reject(err);
        }
    });
};

exports.updateContentRemovals = (removalIds, updateFields) => {
    return new Promise((resolve, reject) => {
        if (!Array.isArray(removalIds) || removalIds.length === 0 || !updateFields || typeof updateFields !== 'object') {
            return resolve(0);
        }

        // Sanitize and validate IDs
        const sanitizedIds = removalIds.map(id => parseInt(id)).filter(id => !isNaN(id));
        if (sanitizedIds.length === 0) {
            return resolve(0);
        }

        // Generate SET clause from updateFields
        const fieldKeys = Object.keys(updateFields);
        const setClause = fieldKeys.map(key => `${key} = ?`).join(', ');
        const values = fieldKeys.map(key => updateFields[key]);

        // Append IDs for WHERE IN clause
        const placeholders = sanitizedIds.map(() => '?').join(',');

        const sql = `UPDATE f_contents_removal SET ${setClause} WHERE cr_id IN (${placeholders})`;

        db.query(sql, [...values, ...sanitizedIds], (err, result) => {
            if (err) {
                reject(err);
            } else {
                resolve(result.affectedRows);
            }
        });
    });
};


// DELETE MULTIPLE CONTENT REMOVAL
exports.deleteContentRemovals = (removalIds) => {
    return new Promise((resolve, reject) => {
        // Check if removalIds is an array and not empty
        if (!Array.isArray(removalIds) || removalIds.length === 0) {
            return resolve(0); // Return 0 if no users to delete
        }

        // Convert all IDs to numbers to prevent SQL injection
        const sanitizedIds = removalIds.map(id => parseInt(id)).filter(id => !isNaN(id));
        
        if (sanitizedIds.length === 0) {
            return resolve(0); // Return 0 if no valid IDs
        }

        // Create placeholders for the query (?, ?, ? etc.)
        const placeholders = sanitizedIds.map(() => '?').join(',');
        
        db.query(
            `DELETE FROM f_contents_removal WHERE cr_id IN (${placeholders})`,
            sanitizedIds,
            (err, result) => {
                if (err) {
                    reject(err);
                } else {
                    // Return the number of affected (deleted) rows
                    resolve(result.affectedRows);
                }
            }
        );
    });
};
