const { countries } = require("../extras/country");
const { scheduleMarketingJobOnCron } = require("../jobs/cron");
const db = require("../models/db");
const { getAllActiveMarketingSchedules, handleScheduleCallback, getMarketingRunningJobByScheduleId } = require("./marketing");

/* (async () => {
  for (const country of countries) {
    const sql = `INSERT INTO f_countries (c_name, c_short_name, c_icon) VALUES (?, ?, ?)`;
    const values = [
      country.name,
      country.iso2,
      country.flag ? country.flag : null,
    ];

    try {
      await new Promise((resolve, reject) => {
        db.query(sql, values, (err, result) => {
          if (err) {
            console.error(`Error inserting country ${country.name}:`, err);
            reject(err);
          } else {
            console.log(`Country ${country.name} inserted successfully.`);
            resolve();
          }
        });
      });
    } catch (err) {
      // Optionally break or continue on error
    }
  }
})(); */



exports.scheduleActiveMarketingJobOnStart = async function () {
    try {
      const activeJobs = await getAllActiveMarketingSchedules();
      if (!activeJobs.length) return false;
  
      await Promise.all(
        activeJobs.map(async (job) => {
          try {
            const cronTime = job.ms_cron_schedule;
            const jobId = job.ms_id;
  
            const isJobRunning = await getMarketingRunningJobByScheduleId(job.ms_id);
            if (!isJobRunning) {
              await scheduleMarketingJobOnCron(cronTime, jobId, async () =>
                handleScheduleCallback(jobId)
              );
            }
          } catch (error) {
            console.error(`Error scheduling job ${job.ms_id}:`, error);
            // Optionally: rethrow if you want all to fail on one error
          }
        })
      );
  
      return true;
    } catch (err) {
      console.error("Failed to schedule jobs:", err);
      throw err;
    }
  };
  