const moment = require("moment");

const months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]

exports.getDateFormatForPost = (date) => {
    const newDate = new Date(date);
    return `${months[newDate.getMonth()]} ${newDate.getDate()}, ${newDate.getFullYear()}`
}

exports.extractTime = (time, format) => {
    return moment(time).format(format)
}

exports.addMinuteToDate = (minutes = 0) => {
    return new Date(new Date().getTime() + (minutes * 60 * 1000))
}


exports.days_between = (date) => {

    // The number of milliseconds in one day
    const ONE_DAY = 1000 * 60 * 60 * 24;

    // Calculate the difference in milliseconds
    const differenceMs = Math.abs(new Date() - date);

    // Convert back to days and return
    return Math.round(differenceMs / ONE_DAY);

}


exports.formatDurationToIso8601 = function (seconds) {
  seconds = Math.floor(seconds); // just in case it’s a float
  const hours = Math.floor(seconds / 3600);
  const minutes = Math.floor((seconds % 3600) / 60);
  const secs = seconds % 60;

  let result = 'PT';
  if (hours) result += `${hours}H`;
  if (minutes) result += `${minutes}M`;
  if (secs || (!hours && !minutes)) result += `${secs}S`; // always show seconds if no hour/minute

  return result;
}