const db = require("../models/db")
const { calculatePerformanceScore } = require("./calculation")


//CREATE NEW REFERRAL
exports.createNewReferral = (obj) => {
    return new Promise((resolve, reject) => {
        db.query("INSERT INTO f_referrals SET ? ", obj,(err, data) => {
            if (err) reject(err)
            else resolve(data)
        })
    })
}

//GET REFERRAL DETAILS BY DOWNLINE (REFERREE)
exports.editReferralDetails = (referralID,obj) => {
    return new Promise((resolve, reject) => {
        db.query("UPDATE f_referrals SET ? WHERE r_id = ?", [obj, parseInt(referralID)],(err, data) => {
            if (err) reject(err)
            else resolve(data)
        })
    })
}

//GET REFERRAL DETAILS BY DOWNLINE (REFERREE)
exports.getReferralDetails = (downlineId) => {
    return new Promise((resolve, reject) => {
        db.query("SELECT * FROM f_referrals A JOIN f_users B ON A.r1_id = B.uid JOIN f_users_essentials C ON C.ue_user_id = A.r1_id WHERE r2_id = ?", parseInt(downlineId),(err, data) => {
            if (err) reject(err)
            else resolve(data[0])
        })
    })
}

//GET REFERRAL COUNT
exports.getUserReferralCount = (userId) => {
    return new Promise((resolve, reject) => {
        
        db.query(`SELECT COUNT(*) AS total FROM f_referrals A WHERE A.r1_id = ${parseInt(userId)} AND r_status = 1`, (err, data) => {
            if (err) reject(err)
            else return resolve(data[0].total || 0)
        })
        
        
    })
}



//GET USER REFERRERS
exports.getUserReferrals = (obj) => {
    return new Promise(async (resolve, reject) => {
        try {
            // Build dynamic filters
            let filters = `WHERE A.r1_id = ${obj.query.userId}`;

            if (obj.query.status && obj.query.status.toLowerCase() !== 'all') {
                filters += ` AND r_status = '${obj.query.status}'`;
            }

            // Build SQL queries for pagination
            const query = `SELECT * FROM f_referrals A JOIN f_users B ON A.r2_id = B.uid ${filters} ORDER BY r_id DESC LIMIT ${obj.query.limit} OFFSET ${obj.query.offset};`;

            const countQuery = `SELECT COUNT(*) as totalCount FROM f_referrals A JOIN f_users B ON A.r2_id = B.uid ${filters};`;

            const dbInstance = obj.connection || db;

            const [dataResult, countResult] = await Promise.all([
                new Promise((res, rej) => dbInstance.query(query, (err, data) => err ? rej(err) : res(data))),
                new Promise((res, rej) => dbInstance.query(countQuery, (err, data) => err ? rej(err) : res(data))),
            ]);

            return resolve({
                referrals: dataResult,
                totalCount: countResult[0].totalCount
            });

        } catch (err) {
            return reject(err);
        }
    });
};

exports.getTopReferrer = (obj = {}) => {
    return new Promise((resolve, reject) => {
        // Validate and set default parameters
        const period = ['thisMonth', 'lastMonth', 'allTime'].includes(obj.period) 
            ? obj.period 
            : 'thisMonth';
        const limit = typeof obj.limit === 'number' ? obj.limit : 10;

        // Define date conditions for each period
        const dateConditions = {
            thisMonth: `r.r_created_at >= DATE_FORMAT(NOW(), '%Y-%m-01')`,
            lastMonth: `r.r_created_at >= DATE_FORMAT(DATE_SUB(NOW(), INTERVAL 1 MONTH), '%Y-%m-01') 
                       AND r.r_created_at < DATE_FORMAT(NOW(), '%Y-%m-01')`,
            allTime: `1=1` // No date filter
        };

        const query = `
        SELECT 
            u.uid AS id,
            u.fullname AS name,
            u.email,
            u.phone,
            u.avatar,
            u.referral_code,
            u.created_at AS created_at,
            u.created_at AS join_date,
            ue.ue_referral_balance AS referral_balance,
            ue.ue_deposit_balance AS deposit_balance,
            ue.ue_user_type AS user_type,
            COUNT(r.r_id) AS total_referrals,
            SUM(CASE WHEN r.r_status = 1 THEN 1 ELSE 0 END) AS active_referrals,
            SUM(CASE WHEN r.r_status = 0 THEN 1 ELSE 0 END) AS pending_referrals,
            SUM(r.r_amount) AS total_revenue,
            MAX(r.r_created_at) AS last_referral_date,
            '${period}' AS period  -- Include period in results for reference
        FROM 
            f_users u
        JOIN 
            f_referrals r ON u.uid = r.r1_id
        LEFT JOIN
            f_users_essentials ue ON u.uid = ue.ue_user_id
        WHERE 
            ${dateConditions[period]}
        GROUP BY 
            u.uid, u.fullname, u.email, u.phone, u.avatar, u.referral_code, 
            u.created_at, ue.ue_referral_balance, ue.ue_deposit_balance, ue.ue_user_type
        ORDER BY 
            total_referrals DESC, total_revenue DESC
        LIMIT ?
        `;

        db.query(query, [limit], (err, data) => {
            if (err) {
                reject(err);
            } else {
                // Format the data
                const result = {
                    period: period,
                    limit: limit,
                    referrers: data.map(referrer => ({
                        ...referrer,
                        referral_balance: parseFloat(referrer.referral_balance),
                        deposit_balance: parseFloat(referrer.deposit_balance),
                        total_revenue: parseFloat(referrer.total_revenue),
                        join_date: new Date(referrer.join_date).toLocaleDateString(),
                        last_referral_date: referrer.last_referral_date 
                            ? new Date(referrer.last_referral_date).toLocaleDateString() 
                            : 'Never',
                        performance_score: calculatePerformanceScore(referrer) // Bonus metric
                    }))
                };
                resolve(result);
            }
        });
    });
};


exports.getReferralStats = (obj) => {
    return new Promise((resolve, reject) => {
        const query = `WITH
    current_month AS(
    SELECT
        COUNT(*) AS total,
        SUM(
            CASE WHEN r_status = 1 THEN 1 ELSE 0
        END
) AS active,
SUM(
    CASE WHEN r_status = 0 THEN 1 ELSE 0
END
) AS pending,
SUM(r_amount) AS revenue
FROM
    f_referrals
WHERE
    r_created_at >= DATE_FORMAT(NOW(), '%Y-%m-01')),
    last_month AS(
    SELECT
        COUNT(*) AS total,
        SUM(
            CASE WHEN r_status = 1 THEN 1 ELSE 0
        END
) AS active,
SUM(
    CASE WHEN r_status = 0 THEN 1 ELSE 0
END
) AS pending,
SUM(r_amount) AS revenue
FROM
    f_referrals
WHERE
    r_created_at >= DATE_FORMAT(
        DATE_SUB(NOW(), INTERVAL 1 MONTH),
        '%Y-%m-01') AND r_created_at < DATE_FORMAT(NOW(), '%Y-%m-01'))
    SELECT
        JSON_OBJECT(
            'totalReferral',
            JSON_OBJECT(
                'currentMonth',
                IFNULL(cm.total, 0),
                'lastMonth',
                IFNULL(lm.total, 0),
                'percentageChange',
                CASE WHEN IFNULL(lm.total, 0) = 0 AND IFNULL(cm.total, 0) = 0 THEN 0 WHEN IFNULL(lm.total, 0) = 0 THEN 100 ELSE ROUND(
                    (
                        (IFNULL(cm.total, 0) - lm.total) / lm.total
                    ) * 100
                )
            END
        ),
        'activeReferral',
        JSON_OBJECT(
            'currentMonth',
            IFNULL(cm.active, 0),
            'lastMonth',
            IFNULL(lm.active, 0),
            'percentageChange',
            CASE WHEN IFNULL(lm.active, 0) = 0 AND IFNULL(cm.active, 0) = 0 THEN 0 WHEN IFNULL(lm.active, 0) = 0 THEN 100 ELSE ROUND(
                (
                    (
                        IFNULL(cm.active, 0) - lm.active
                    ) / lm.active
                ) * 100
            )
        END
    ),
    'pendingReferral',
    JSON_OBJECT(
        'currentMonth',
        IFNULL(cm.pending, 0),
        'lastMonth',
        IFNULL(lm.pending, 0),
        'percentageChange',
        CASE WHEN IFNULL(lm.pending, 0) = 0 AND IFNULL(cm.pending, 0) = 0 THEN 0 WHEN IFNULL(lm.pending, 0) = 0 THEN 100 ELSE ROUND(
            (
                (
                    IFNULL(cm.pending, 0) - lm.pending
                ) / lm.pending
            ) * 100
        )
    END
),
'referralRevenue',
JSON_OBJECT(
    'currentMonth',
    IFNULL(cm.revenue, 0),
    'lastMonth',
    IFNULL(lm.revenue, 0),
    'percentageChange',
    CASE WHEN IFNULL(lm.revenue, 0) = 0 AND IFNULL(cm.revenue, 0) = 0 THEN 0 WHEN IFNULL(lm.revenue, 0) = 0 THEN 100 ELSE ROUND(
        (
            (
                IFNULL(cm.revenue, 0) - lm.revenue
            ) / lm.revenue
        ) * 100
    )
END
)
) AS stats
FROM
    current_month cm,
    last_month lm`;

        db.query(query, obj, (err, data) => {
            if (err) {
                reject(err);
            } else {
                // Parse the JSON stats and return as object
                const result = data[0] ? JSON.parse(data[0].stats) : {
                    totalReferral: { currentMonth: 0, lastMonth: 0, percentageChange: 0 },
                    activeReferral: { currentMonth: 0, lastMonth: 0, percentageChange: 0 },
                    pendingReferral: { currentMonth: 0, lastMonth: 0, percentageChange: 0 },
                    referralRevenue: { currentMonth: 0, lastMonth: 0, percentageChange: 0 }
                };
                resolve(result);
            }
        });
    });
};


exports.adminGetReferralHistory = (obj) => {
    return new Promise(async (resolve, reject) => {
        try {
            // Validate and set default parameters
            const { status = 'all', search = '', limit = 10, offset = 0 } = obj.query || {};

            // Build dynamic filters
            let filters = 'WHERE 1=1';
            const params = [];

            // Status filter
            if (status !== 'all') {
                let statusValue;
                if (status.toLowerCase() === 'pending') {
                    statusValue = 0;
                } else if (status.toLowerCase() === 'active') {
                    statusValue = 1;
                }
                
                if (statusValue !== undefined) {
                    filters += ' AND r.r_status = ?';
                    params.push(statusValue);
                }
            }

            // Search filter (referrer or referred user name/email)
            if (search) {
                filters += ` AND (
                    referrer.fullname LIKE ? OR 
                    referrer.email LIKE ? OR
                    referred.fullname LIKE ? OR
                    referred.email LIKE ?
                )`;
                const searchTerm = `%${search}%`;
                params.push(searchTerm, searchTerm, searchTerm, searchTerm);
            }

            // Main query with pagination
            const query = `
                SELECT 
                    r.r_id AS referral_id,
                    referrer.uid AS referrer_id,
                    referrer.fullname AS referrer_name,
                    referrer.email AS referrer_email,
                    referrer.avatar AS referrer_avatar,
                    referrer.referral_code AS referrer_code,
                    referred.uid AS referred_id,
                    referred.fullname AS referred_name,
                    referred.email AS referred_email,
                    referred.avatar AS referred_avatar,
                    referred.referral_code AS referred_code,
                    DATE_FORMAT(r.r_created_at, '%Y-%m-%d %H:%i:%s') AS join_date,
                    DATE_FORMAT(referred.updated_at, '%Y-%m-%d %H:%i:%s') AS last_activity,
                    CASE 
                        WHEN r.r_status = 1 THEN 'Active'
                        WHEN r.r_status = 0 THEN 'Pending'
                        ELSE 'Inactive'
                    END AS status,
                    r.r_amount AS earnings,
                    referrer_essentials.ue_referral_balance AS referrer_balance,
                    referred_essentials.ue_user_type AS referred_user_type,
                    referrer_essentials.ue_user_type AS referrer_user_type
                FROM 
                    f_referrals r
                JOIN 
                    f_users referrer ON r.r1_id = referrer.uid
                JOIN 
                    f_users referred ON r.r2_id = referred.uid
                LEFT JOIN
                    f_users_essentials referrer_essentials ON referrer.uid = referrer_essentials.ue_user_id
                LEFT JOIN
                    f_users_essentials referred_essentials ON referred.uid = referred_essentials.ue_user_id
                ${filters}
                ORDER BY 
                    r.r_id DESC
                LIMIT ? OFFSET ?
            `;

            // Count query for pagination
            const countQuery = `
                SELECT COUNT(*) as totalCount
                FROM f_referrals r
                JOIN f_users referrer ON r.r1_id = referrer.uid
                JOIN f_users referred ON r.r2_id = referred.uid
                ${filters}
            `;

            // Add pagination parameters
            params.push(parseInt(limit), parseInt(offset));

            const dbInstance = obj.connection || db;

            // Execute both queries in parallel
            const [dataResult, countResult] = await Promise.all([
                new Promise((res, rej) => 
                    dbInstance.query(query, params, (err, data) => 
                        err ? rej(err) : res(data)
                    )
                ),
                new Promise((res, rej) => 
                    dbInstance.query(countQuery, params.slice(0, -2), (err, data) => 
                        err ? rej(err) : res(data)
                    )
                )
            ]);

            resolve({
                history: dataResult,
                totalCount: countResult[0].totalCount
            });

        } catch (err) {
            reject(err);
        }
    });
};