const db = require("../models/db");

//CREATE NEW SCRAPPED CONTENT
exports.createScrappedContent = (obj) => {
    return new Promise((resolve, reject) => {
        db.query("INSERT INTO f_scrapped_contents SET ?", obj, (err, data) => {
            if (err) reject(err)
            else resolve(data)
        })
    })
};

//GET SCRAPPED CONTENTS
exports.getScrappedContents = (obj) => {
    return new Promise(async (resolve, reject) => {
        try {
            // Build dynamic filters
            let filters = `WHERE sc_status = 'draft'`;

            if (obj.query.search) {
                filters += ` AND (sc_title LIKE '%${obj.query.search}%' OR sc_link LIKE '%${obj.query.search}%')`;
            }

            // Build SQL queries for pagination
            const query = `SELECT * FROM f_scrapped_contents ${filters} LIMIT ${obj.query.limit} OFFSET ${obj.query.offset};`;
            
            const countQuery = `SELECT COUNT(*) as totalCount FROM f_scrapped_contents ${filters};`;

            const dbInstance = obj.connection || db;

            const [dataResult, countResult] = await Promise.all([
                new Promise((res, rej) => dbInstance.query(query, (err, data) => err ? rej(err) : res(data))),
                new Promise((res, rej) => dbInstance.query(countQuery, (err, data) => err ? rej(err) : res(data))),
            ]);

            return resolve({
                contents: dataResult,
                totalCount: countResult[0].totalCount
            });

        } catch (err) {
            return reject(err);
        }
    });
};

// DELETE MULTIPLE SCRAPPED CONTENT
exports.deleteScrappedContent = (contentIds) => {
    return new Promise((resolve, reject) => {
        // Check if contentIds is an array and not empty
        if (!Array.isArray(contentIds) || contentIds.length === 0) {
            return resolve(0); // Return 0 if no users to delete
        }

        // Convert all IDs to numbers to prevent SQL injection
        const sanitizedIds = contentIds.map(id => parseInt(id)).filter(id => !isNaN(id));
        
        if (sanitizedIds.length === 0) {
            return resolve(0); // Return 0 if no valid IDs
        }

        // Create placeholders for the query (?, ?, ? etc.)
        const placeholders = sanitizedIds.map(() => '?').join(',');
        
        db.query(
            `DELETE FROM f_scrapped_contents WHERE sc_id IN (${placeholders})`,
            sanitizedIds,
            (err, result) => {
                if (err) {
                    reject(err);
                } else {
                    // Return the number of affected (deleted) rows
                    resolve(result.affectedRows);
                }
            }
        );
    });
};

//EDIT SCRAPPED CONTENT
exports.editScrappedContent = (id, obj) => {
    return new Promise((resolve, reject) => {
        db.query("UPDATE f_scrapped_contents SET ? WHERE sc_id = ?", [obj, id], (err, data) => {
            if (err) reject(err)
            else resolve(data)
        })
    })
};