const logger = require("../helpers/logger");

const errorMiddleWare = (err, req, res, next) => {

    if (process.env.NODE_ENV && process.env.NODE_ENV.trim() === "dev") {
        console.log(err)
    }
  
    logger.error(err)

    if (req.headers['is_native_app']){

        return res.status(err.statusCode || 500).send({
            success: false,
            message: err.message || "Something Went Wrong" || "Server Error"
        })

    }else{
        //FOR WEBSITE
        if (req.method.toLowerCase() == "get") return res.render("error/error", {
            title: "Something Went Wrong",
            text: err.message || "Server Error"
        })

        else return res.status(err.statusCode || 500).send({
            success: false,
            message: "Something Went Wrong" || "Server Error"
        })

    }

    
    
}

module.exports = errorMiddleWare